; -----------------------------------------------------------------------
;Программа управления режимами фонарика Police 20W на PIC10F220
;C = 0uF, R = 200K, VD - BAS316
; Template source file generated by piklab
    #include <p10f220.inc>

; -----------------------------------------------------------------------
; Configuration bits: adapt to your setup and needs
    __CONFIG _IOFSCS_4MHZ & _MCPU_ON & _WDT_OFF & _CP_OFF & _MCLRE_OFF

; -----------------------------------------------------------------------
#define	LED	GPIO,GP1	;
#define	VSens	GPIO,GP2	;
#define	ICFG	GPIO,GP0	;

w	equ	1
f	equ	0

INIT_OPTION	EQU	b'10000111'	;

	cblock 0x09
		Temp		;временный регистр
		Mode		;регистр режима
		Count		;временные счетчики
		Count2		;
		CountB		;
		Data		;регистр данных

	endc


; -----------------------------------------------------------------------
; relocatable code
;PROG CODE
		org	0x000
		goto	Start

;///////////
Read_ADC	bsf	ADCON0,ADON
		bsf	ADCON0,GO
R_ADC		btfsc	ADCON0,GO
		goto	R_ADC
		movf	ADRES,w
		bcf	ADCON0,ADON
		movwf	Data
		return

Delay_05ms	movlw	.124		;задержка 500мкс
		movwf	Count
ld05		nop
		decfsz	Count
		goto	ld05
		return

Delay_1ms	movlw	.249		;задержка 1мс
		movwf	Count
ld1		nop
		decfsz	Count
		goto	ld1
		return

Delay_5ms	call	Delay_1ms
		call	Delay_1ms
		call	Delay_1ms
		call	Delay_1ms
		call	Delay_1ms
		return

Port_CFG	movlw	b'00001101'	;GP1 - выход
		movwf	GPIO
		TRIS	GPIO
		bsf	ICFG		;ICFG - pull-up On
		bsf	GPIO,GP3
		return


; -----------------------------------------------------------------------

Start		;инициализация PIC
		movwf	OSCCAL		;Загружаем калибровочный байт

		movlw	INIT_OPTION

		OPTION

		clrf	TMR0

		movlw	b'00001000'
		movwf	ADCON0

		movlw	.40		;
		movwf	CountB

		call	Delay_05ms

; -----------------------------------------------------------------------
Main		

Read_Mode	btfss	VSens
		goto	Sleep_Mode

Mode_Pwr	call	Port_CFG

;1-30%
;2-100%
		movf	Mode,f
		btfss	STATUS,Z
		goto	Next_Mode
Start_Mode	movlw	.1
		movwf	Mode
		goto	Read_ICFG

Next_Mode	movlw	.2
		subwf	Mode,w
		btfsc	STATUS,Z
		goto	Start_Mode
		incf	Mode,f


;///////////
Read_ICFG	btfss	VSens
		goto	Sleep_Mode

		btfss	ICFG		;если ICFG=0 - отключить проверку напряжения
		goto	Mode_Sel

Bat_Sens	decfsz	CountB
		goto	Mode_Sel

		movlw	.20
		movwf	CountB

		call	Read_ADC
;Data=0.6/(VDD/256)
;Uf=0.495V;0.05V
;1.6V=93
;3.2V=47
;4.2V=36

Bat_1V6		movlw	.130		;1.6 (>130)
		subwf	Data,w
		btfsc	STATUS,C
		goto	Mode_On

Bat_3V2		movlw	.58		;3.2 (<57)
		subwf	Data,w
		btfsc	STATUS,C
		goto	Mod_LB

;///////////
Mode_Sel
Mod_PWM		btfss	Mode,0
		goto	Mod_100

		bsf	LED		;PWM 40% 200Hz
		call	Delay_1ms
		call	Delay_1ms
		bcf	LED
		call	Delay_1ms
		call	Delay_1ms
		call	Delay_1ms

		goto	Read_ICFG


Mod_100		btfss	Mode,1
		goto	Mode_Err
		bsf	LED
		call	Delay_5ms
		goto	Read_ICFG

;///////////
Mod_LB		call	Read_ADC
		movlw	.63		;3.0 (<62)
		subwf	Data,w
		btfsc	STATUS,C
		goto	Mode_Off
M_LB_On		bsf	LED
		call	Delay_05ms
		bcf	LED
		call	Delay_05ms
		call	Delay_1ms
		call	Delay_1ms
		call	Delay_1ms
		call	Delay_1ms
		clrf	Mode
		goto	Mod_LB


Mode_Err	clrf	Mode
		goto	Main


Mode_Off	bcf	LED
M_Off		call	Delay_1ms
		goto	M_Off


Mode_On		bsf	LED
M_On		call	Delay_1ms
		goto	M_On


Sleep_Mode	
		sleep


END
